% This function calculates the hydrograph properties (terms in Eq. 34, 35 &
% 36).

% Sc (terms in Eq. 34, 35 & 36):
% 1)Volume, 2)Centroid, 3)Spreadness

% T: time period of the flow event;
% flow: time series of flow;
% bf: time series of baseflow.

function Sc=AFF(T,flow,bf)
T=(1:length(T))';

% Eq.(34)
V_f=sum(flow-bf);
% I_f=mean(flow-bf);

if V_f>0
% Eq.(35)
  C_f=sum(T.*(flow-bf))/V_f;

% Eq.(36)
  S_f2=sum((T-C_f).^2.*(flow-bf))/V_f;
  S_f=sqrt(S_f2);

else
% Eq.(35)
  C_f=(length(T)+1)/2;

% Eq.(36)
  S_f2=(length(T)^2+1)/12;
  S_f=sqrt(S_f2);
end

% Sc=[V_f I_f C_f S_f2 S_f];
Sc=[V_f C_f S_f]; % N by 3
